#-----------------------------------------------------------------------------#
#Script created in version RStudio 4.0.4 by Marianna Fusco 
#The script is for the analysis of data related to the following paper:
#Lithic variability and raw material exploitation at the Middle Stone Age (MSA) 
#site of Gotera, southern Ethiopia: a combined technological and quantitative approach

#Marianna Fusco 1
#Elena Carletti 1
#Marina Gallinaro 1
#Andrea Zerboni 2
#Enza Elena Spinapolice 1

#Affiliations
#1 Dipartimento di Scienze dell'Antichit,La Sapienza Universit di Roma. 
#Piazzale Aldo Moro 5, 00 185 Rome, Italy
#2 Dipartimento di Scienze della Terra "Ardito Desio", Universit degli Studi di Milano. 
#via Mangiagalli 34, 20133 Milan, Italy

## Corresponding author: marianna.fusco@uniroma1.it


#Packages required####
require(ggplot2)
require(readxl)
require(FactoMineR)
require(Factoshiny)
require(factoextra)


#PCA section 4.2, first part_Flakes####
#### Cleaning workspace and figure #
rm(list = ls()) # cleaning environment
graphics.off()  # cleaning PLOT
cat("\014")   # cleaning console


#### loading packages #
library(ggplot2) # for graphs
library(readxl) #for reading excel files
library(factoextra)


##### select directory #
setwd ("C:\\Users\\MattiaDiCicco\\Desktop\\PCA per pulisci sassi") 



##### load dataset###
Flakes <- read_xlsx("Flakes.xlsx", sheet = 2)
# working on variables to convert in factors#
Flakes$RM1<- as.factor(Flakes$RM1)
Flakes$PLP <- as.factor(Flakes$PLP)
Flakes$TCHTY <- as.numeric(Flakes$TCHTY)
Flakes$Type <- as.factor(Flakes$Type)

### selecting the numerical variables to perform PCA on flakes###
# Raw materials were not considered as variables 
Flk_PCA  = Flakes
Flk_PCA$RM1<- NULL
Flk_PCA$PLP <- NULL
Flk_PCA$Type <- NULL 
Flk_PCA$ID <- NULL
Flk_PCA$CTX <- NULL
Flk_PCA$PLM <- NULL


# PCA#
group <- as.factor (Flakes$RM1) #isolating RM1 as variables for raw materials

PCA = prcomp(Flk_PCA,scale. = TRUE) # to run PCA using the variables previously selected

# visualizing the results

fviz_pca_ind(PCA, # PCA
             col.ind = group, # to colour groups
             geom = "point",  # to visualize ID as points in the graph
             palette = c("red", "black"), 
             addEllipses = TRUE, # creating the ellipses to cluster results
             ellipse.type = "t",
             legend.title = "Groups", # Legend
             repel = TRUE) #avoiding the overlapping among geometries 

#### PCA on cores_section 4.2 second part ####
#cleaning workspace
rm(list = ls()) # cleaning environment environment
graphics.off()  # cleaning PLOT
cat("\014")   # Cleaning console


#### loading packages #
library(ggplot2) 
library(readxl) 
library(factoextra)


##### selecting workspace directory #
setwd ("C:\\Users\\MattiaDiCicco\\Desktop\\PCA per pulisci sassi") 



##### load data#
Cores <- read.csv("Cores.csv", sep=";")

# Cleaning variables #
Cores$..ID <- NULL
Cores$NSP <- NULL
Cores$NTSP <- NULL
Cores$REG <- NULL
Cores$REGTYPE <- NULL
Cores$CTX <- NULL
Cores$Flakes.removed <- NULL
# creating a copy dataset avoiding raw material as variable
Cores_c = Cores
Cores_c$Raw.Material <- NULL
#PCA
group <- as.factor (Cores$Raw.Material) 

PCA = prcomp(nuclei_c[],scale. = TRUE) 

#PCA results_figure 10

fviz_pca_ind(PCA, #PCA
             col.ind = group, # Colouring points
             geom = "point",  # visualizing ID as points
             palette = c("blue", "red"), # colours of groups
             addEllipses = TRUE, # creating ellipses to cluster results
             ellipse.type = "t",
             legend.title = "Groups", # legend
             repel = TRUE) # voiding the overlapping among geometries 




#Correspondence analysis, section 4.2 last part####
library(FactoMineR)
library(Factoshiny)
#CA for flakes####
#import dataser_Flakes_Quali to explore categorical variables
library(readxl)
library(readxl)
Flakes_Quali2 <- read_excel("C:/Users/Flavio/Desktop/Paper Fusco et al nuovo/paper to submit/final version/Paper revisioni/ultimissime versioni/Submission/Submission_Fusco et al/RawData_Fusco et al/Database_Raw/CA/Flakes_Quali2.xlsx", 
                            col_types = c("text", "numeric", "numeric", 
                                          "numeric", "numeric", "numeric", 
                                          "numeric", "numeric", "numeric", 
                                          "numeric", "numeric", "numeric", 
                                          "numeric", "numeric", "numeric", 
                                          "numeric", "numeric", "numeric", 
                                          "numeric", "numeric", "numeric", 
                                          "numeric"))
View(Flakes_Quali2)
Flakes_Quali2 <- read_excel() #Import Dataset
summary(Flakes_Quali2)#to show variables
View(Flakes_Quali2)
str(Flakes_Quali2)
summary(Flakes_Quali2)
library(Factoshiny)
CA <-Factoshiny(Flakes_Quali2)
#To create plot for Figure 13
plot.CA(res.CA,selectRow='cos2 0',unselect=0,cex=0.75,cex.main=0.75,cex.axis=0.75,title="CA flake analysis",col.row='#000003',col.quali.sup='#0009FF')
res.CA<-CA(Flakes_Quali2,quali.sup=c(1),graph=FALSE)
plot.CA(res.CA,selectRow='cos2 0',unselect=0,cex=0.75,cex.main=0.75,cex.axis=0.75,title="CA flake analysis",col.row='#000003',col.quali.sup='#0009FF')
CA <-Factoshiny(Flakes_Quali2)
CA <-Factoshiny(Flakes_Quali2)
res.CA<-CA(Flakes_Quali2,quali.sup=c(1),graph=FALSE)
summary(res.CA)

#CA for cores####
#importa Dataset Core_quali2 to explore categorical variables
library(readxl)
Core_quali2 <- read_excel("C:/Users/Flavio/Desktop/Paper Fusco et al nuovo/attributi/MCA/Database/DB usati per CA/Core_quali2.xlsx",
                          col_types = c("text", "numeric", "numeric",
                                        "numeric", "numeric", "numeric",
                                        "numeric", "numeric", "numeric",
                                        "numeric", "numeric", "numeric",
                                        "numeric", "numeric", "numeric"))
View(Core_quali2)
summary(Core_quali2)
summary(Core_quali2)#to show variables
library(Factoshiny)
CA2 <-Factoshiny(Core_quali2)
res.CA<-CA(Core_quali2,quali.sup=c(1),graph=FALSE)
#to create the plot for Figure 14
plot.CA(res.CA,cex=0.8,cex.main=0.8,cex.axis=0.8,title="CA Core Analysis",col.row='#05051C',col.quali.sup='#1500FF')








